// UTF-8 encoding
// Copyright 2009 Florent Lioult.

/**
 * @file	AneRouge.cpp
 * @author	Florent Lioult
 * @date	2009
 */

#include "macro.hpp"
#include "Partie.hpp"

using namespace std;

namespace AneRouge {

	void afficherUsage()
	{
		cout << "Usage : ane_rouge [-h | -v | -f fichier] " << endl;
	}

	void afficherAide( char * [] )
	{
		cout
			<< "Vous désirez probablement taper quelque chose comme "
			<<"'./ane_rouge -f ../data/plateau_1.txt' ;)" << endl;
	}

	void afficherVersion( char * [] )
	{
		cout << "Copyright 2009 Florent Lioult" << endl;
	}

	void jouerPartie( char * arguments[] )
	{
		Partie::jouer( arguments[0] );
	}

	/**
	 * @brief	Parcourt la ligne de commande et lance les traitements associés.
	 */
	void parcourirArguments( int nombreArguments, char * arguments[] )
	{
		struct Option
		{
			typedef void (* Action)( char * [] );

			const string clef;
			const Action action;
			const int arite;
		}
		static const OPTIONS[] =
		{
			{ "-h", afficherAide, 0 },
			{ "-v", afficherVersion, 0 },
			{ "-f", jouerPartie, 1 },
		};
		
		if ( nombreArguments > 1 )
		{
			// Tente d'identifier une des options reconnues.
			for ( size_t i = 0; i < (sizeof(OPTIONS) / sizeof(Option)); ++i )
			{
				if ( OPTIONS[i].clef == arguments[1] )
				{
					int nombreParametres = nombreArguments - 2;
					if ( nombreParametres == OPTIONS[i].arite )
					{
						OPTIONS[i].action( arguments + 2 );
						return;
					}
					else
					{
						afficherUsage();
						throw runtime_error( "Nombre de paramètres incorrect." );
					}
				}
			}
		}

		afficherUsage();
		throw runtime_error( "Option manquante." );
	}

} // namespace AneRouge

using namespace AneRouge;

int main( int nombreArguments, char * arguments[] )
{
	try {
		parcourirArguments( nombreArguments, arguments );
		return EXIT_SUCCESS;
	} catch ( const exception & erreur ) {
		cerr << erreur.what() << endl;
		return EXIT_FAILURE;
	}
}
