// UTF-8 encoding
// Copyright 2009 Florent Lioult.

/**
 * @file	DescripteurJeu.hpp
 * @author	Florent Lioult
 * @date	2009
 */

#ifndef ANE_ROUGE__DESCRIPTEUR_JEU_HPP
#define ANE_ROUGE__DESCRIPTEUR_JEU_HPP

#include <vector>
#include <algorithm>

#include "macro.hpp"
#include "Position.hpp"

namespace AneRouge
{
	/**
	 * @brief	Regroupe les informations implicitement liées aux fichiers de
	 *			sérialisation de l'âne rouge.
	 */
	struct DescripteurJeu
	{
		/**
		 * Les pièces du jeu sont nommées par une simple lettre de l'alphabet.
		 */
		// @{
		char					nomAneRouge;
		char					nomBordure;
		std::vector< char >		nomsPiecesVides;
		// @}
		
		static DescripteurJeu creerDescripteurParDefaut()
		{
			DescripteurJeu descripteur;
			
			descripteur.nomAneRouge = 'L';
			descripteur.nomBordure = 'X';
			
			descripteur.nomsPiecesVides.push_back( 'A' );
			descripteur.nomsPiecesVides.push_back( 'B' );
			/*
			On ajoute le '.' pour permettre de désérialiser un plateau sérialisé
			par le programme (lequel ne distingue pas un vide d'un autre).
			*/
			descripteur.nomsPiecesVides.push_back( '.' );
			
			return descripteur;
		}
		
		bool estUnePieceVide( char nomPiece ) const
		{
			std::vector< char >::const_iterator endItr = nomsPiecesVides.end();
			return find( nomsPiecesVides.begin(), endItr, nomPiece ) != endItr;
		}
	};
}

#endif // ANE_ROUGE__DESCRIPTEUR_JEU_HPP
