// UTF-8 encoding
// Copyright 2009 Florent Lioult.

/**
 * @file	Position.hpp
 * @author	Florent Lioult
 * @date	2009
 */

#ifndef ANE_ROUGE__POSITION_HPP
#define ANE_ROUGE__POSITION_HPP

#include "macro.hpp"

namespace AneRouge
{
	enum DIRECTION { NORD, SUD, EST, OUEST, CARD_DIRECTION };

	extern const DIRECTION	DEMI_TOURS[];
	extern const int		DELTA_DIRECTION[][2];
	extern const char *		LIBELLES_DIRECTIONS[];
	
	/**
	 * @brief	Une position 2D entière.
	 */
	struct Position
	{
		std::size_t x_, y_;
		
		Position( std::size_t x, std::size_t y ) :
			x_( x ),
			y_( y )
		{}

		/**
		 * @brief	Retourne une nouvelle position obtenue en décalant cette
		 *			position d'une case dans la direction indiquée.
		 */
		Position decaler( DIRECTION direction ) const
		{
			return Position(
				x_ + DELTA_DIRECTION[direction][0],
				y_ + DELTA_DIRECTION[direction][1] );
		}
		
		/**
		 * @brief	Retourne une nouvelle position obtenue en ajoutant à cette
		 *			position un décalage de cases donnée (exprimé lui-même comme
		 *			une position).
		 */
		Position decaler( const Position & decalage ) const
		{
			return Position(
				x_ + decalage.x_,
				y_ + decalage.y_ );
		}

		Position distance( const Position & position ) const
		{
			return Position(
				x_ > position.x_ ? x_ - position.x_ : position.x_ - x_,
				y_ > position.y_ ? y_ - position.y_ : position.y_ - y_ );
		}
	};
}

#endif // ANE_ROUGE__POSITION_HPP
