// UTF-8 encoding
// Copyright 2009 Florent Lioult.

/**
 * @file	macro.hpp
 * @author	Florent Lioult
 * @date	2009
 */

#ifndef ANE_ROUGE__MACRO_HPP
#define ANE_ROUGE__MACRO_HPP

#include <cstddef>
#include <ciso646>

#include <limits>
#include <stdexcept>

/**
 * @brief   Itère sur une collection non modifiable.
 * @param   typeCollection Le type de la collection sur laquelle on itère.
 * @param   collection La collection sur laquelle on itère.
 * @param   itr Le nom de l'itérateur constant.
 *
 * Exemple :
 * @code
 * ITERE_CONST( std::vector<int>, monTableau, itr )
 * {
 *   printf( "%i\n", *itr );
 * }
 * @endcode
 */
#define ITERER( typeCollection, collection, itr ) \
const typeCollection::iterator end_##itr = collection.end(); \
for (	typeCollection::iterator itr = collection.begin(); \
		itr != end_##itr; \
		++itr )

/**
 * @brief   Itère sur une collection modifiable.
 * @param   typeCollection Le type de la collection sur laquelle on itère.
 * @param   collection La collection sur laquelle on itère.
 * @param   itr Le nom de l'itérateur constant.
 *
 * Exemple :
 * @code
 * ITERE( std::vector<int>, monTableau, itr )
 * {
 *   printf( "%i\n", *itr );
 * }
 * @endcode
 */
#define ITERER_CONST( typeCollection, collection, itr ) \
const typeCollection::const_iterator end_##itr = collection.end(); \
for (	typeCollection::const_iterator itr = collection.begin(); \
		itr != end_##itr; \
		++itr )

/**
 * @brief Définit un type non copiable.
 *
 * Déclare le constructeur et l'opérateur de copie sans les définir,
 * interdisant ainsi la copie d'instances de T.
 */
#define NON_COPIABLE( T ) \
T( const T & ); \
const T & operator = ( const T & );

#endif // ANE_ROUGE__MACRO_HPP
